//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of CPCtelera: An Amstrad CPC Game Engine
//  Copyright (C) 2018 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include <cpctelera.h>
#include "readSdcc.h"

u8 tableSector[256];
char const fileName[12] = "WOLF    SCR";

void main(void) 
{
	u8 i;
	
	// First start motor
	asm_FdcOn();
	
	// Read files needed
	for (i = 0; i < 10; i++)
		asm_LoadFile(fileName, (u8*)0xC000, tableSector);		
	
	// Stop motor
	asm_FdcOff();
	
	// Do stuff
	
	// Restart motor
	asm_FdcOn();
	
	// Read another files needed
	for (i = 0; i < 10; i++)
		asm_LoadFile(fileName, (u8*)0xC000, tableSector);		
	
	// Stop motor
	asm_FdcOff();
	
	while(1);
}
